/*
 * @(#)OMBshLink.java  1.0  23. M�rz 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.objectmodelbsh;

import ch.hslu.cm.simulation.*;
import ch.hslu.cm.oo.objectmodel.*;
import java.util.*;
import javax.swing.event.*;
/**
 * Represents a link between two objects, which can be scripted using BeanShell. 
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 23. M�rz 2004  Created.
 */
public class OMBshLink extends OMBidirectionalLink {
    /**
     * This is set to true, when the link is used to transmit a response.
     * This is set to false, when the link is used to transmit a message.
     */
    private boolean isResponse = false;
    
    /**
     * The message being transmitted by this link.
     */
    private Object message;
    /**
     * The response being transmitted by this link.
     */
    private Object response;
    
    /**
     * The receiver of the message.
     */
    private SimulatedObject receiver;
    
    /**
     * This value is used to observe simulated message sending.
     * <p>
     * A value of -1 indicates that no message is being sent by this
     * link.
     * <br>A value of 0 indicates that a message is located at the
     * source of the link.
     * <br>A value of 100 indicates that a message is located at the
     * target of the link.
     * <br>A value between 0 and 100 indicates that a message is moving
     * from source to target or from target to source.
     */
    private int progress = -1;

    /** Creates a new instance. */
    public OMBshLink() {
    }
    
    /**
     * Returns the current progress of a message.
     * <p>
     * A value of -1 indicates that no message is being sent by this
     * link.
     * <br>A value of 0 indicates that a message is located at the
     * source of the link.
     * <br>A value of 100 indicates that a message is located at the
     * target of the link.
     * <br>A value between 0 and 100 indicates that a message is moving
     * from source to target or from target to source.
     */
    public int getProgress() {
        return progress;
    }
    
    /**
     * Sets the progress of the message.
     */
    protected void setProgress(int i) {
        progress = i;
        fireStateChanged();
    }
    /**
     * Sends a message to the receiver.
     *
     * @param msg The message to be sent (in UML notation).
     * @param receive The receiver of the message. The receiver must be
     * either the source or the target of this link.
     */
    public void sendMessageTo(Object msg, SimulatedObject receiver, boolean isResponse) {
        if (getSimulation().getDelay() == 0) return;
        
        this.isResponse = isResponse;
        if (isResponse) {
            response = msg;
        } else {
            String varName = receiver.getName();
            message = (varName == null) ? msg : varName + "." + msg;
            this.receiver = receiver;
        }
        activate();
        if (msg != Void.TYPE) {
            try { Thread.sleep(Math.max(1, getSimulation().getDelay() / 20)); } catch (InterruptedException e) {}
            if (receiver == getEnd()) {
                for (int i=0; i <= 100; i+=2) {
                    try { Thread.sleep(Math.max(1, getSimulation().getDelay() / 50)); } catch (InterruptedException e) {}
                    setProgress(i);
                }
            } else {
                for (int i=100; i >= 0; i-=2) {
                    try { Thread.sleep(Math.max(1, getSimulation().getDelay() / 50)); } catch (InterruptedException e) {}
                    setProgress(i);
                }
            }
            try { Thread.sleep(Math.max(1, getSimulation().getDelay() / 20)); } catch (InterruptedException e) {}
        }
        if (isResponse) {
            response = null;
            message = null;
            this.receiver = null;
            setProgress(-1);
        }
        deactivate();
    }
}
